#include "HardwareProfile.h"
#include "TCPIP Stack/TCPIP.h"
#include "TCPIP Stack/ZG2100.h"

volatile BOOL interruptEnableFlag = FALSE;

    /*NOTE: This code may need to be modified for other hardware configurations */
tZGBool zgHalIsEintDisabled(tZGVoidInput)
{
	return(interruptEnableFlag == FALSE);
}

tZGBool zgHalIsEintPending(tZGVoidInput)
{  
	return ( (interruptEnableFlag == TRUE) && (ZG_EINT_IO == 0u) );
}

//============================================================================
tZGVoidReturn zgHALEintEnable(tZGVoidInput)
// satisfies ZG Driver function Hook
//============================================================================
{
	// if interrupt line is low, then we may have missed a falling edge
	// while the interrupt was disabled.
	if ( ZG_EINT_IO == 0 )
	{
		// if the interrupt pin is active
		// then the ZG2100 has another event that needs to be serviced.
		// This means that the ZG2100 will never generate another falling edge
		// required to trigger the interrupt... So, we must force an interrupt.
		// force the EINT
		zgDriverEintHandler();
	}
	
	/* enable the external interrupt */
	interruptEnableFlag = TRUE;
}


//============================================================================
// satisfies ZG Driver function Hook
tZGVoidReturn zgHALEintDisable(tZGVoidInput)
//============================================================================
{
	/* disable the external interrupt */
	interruptEnableFlag = FALSE;
}

//============================================================================
//* satisfies ZG Driver function Hook
tZGVoidReturn zgHALEintInit(tZGVoidInput)
//============================================================================
{
	/* disable the external interrupt */
	interruptEnableFlag = FALSE;
	
	/* configure IO pin as input and External Interrupt pin*/
	/* set the I/O high since we do not have pull-ups */
	ZG_EINT_IO   = 1;
	ZG_EINT_TRIS = 1;
	
	/* clear and enable the interrupt */
	zgHALEintDisable();
	zgHALEintEnable();
	
	// Use Timer 2 for 16-bit and 32-bit processors
	// 1:1 prescale
	T2CONbits.TCKPS = 0;
	// Base
	PR2 = 0xFFFF;
	// Clear counter
	TMR2 = 0;

	IPC2bits.T2IP = 4;	// Interrupt priority 4
	IFS0CLR = _IFS0_T2IF_MASK;
	IEC0SET = _IEC0_T2IE_MASK;

	// Start timer
	T2CONbits.TON = 1;	
}

void __attribute((interrupt(ipl4), vector(_TIMER_2_VECTOR), nomips16)) _T2Interrupt(void)
{
	// try to process interrupts from WiFi module here
	if( zgHalIsEintPending() )
		zgDriverEintHandler();
		
	// Reset interrupt flag
	IFS0CLR = _IFS0_T2IF_MASK;
}

